
sounds = 
{
-------------------------------------------------
addSound = function(id, stime, stype, sx, sy, sz, sf, sowner)
calls.enter("sounds.addSound",id..","..stype..","..sowner)
	local finded = false
	if(stype=="shot") then
		finded = memory.touchKnownBySound(id,sowner,sx, sy, sz, sf)
	end
	if(not finded) then

		local sndID = sowner..stype

		local find = function(index, value)
			if(value.soundID==sndID) then 
				finded = true
				value.x = sx
				value.y = sy
				value.z = sz
				value.f = sf
				value.time = stime
				return(1)
			end
		end

		table.foreach(Humans[id].memory.clear_sounds,find)
		if(not finded) then 
			local new_sound = 
			{
				soundID = sndID,
				time = stime, 
				type = stype, 
				x = sx, 
				y = sy, 
				z = sz,
				f = sf, 
				owner = sowner
			}
			table.insert(Humans[id].memory.clear_sounds, deepcopy(new_sound))
		end
	end
calls.leave("sounds.addSound",id..","..stype..","..sowner)
end, 
-------------------------------------------------
isSoundDangerous = function(soundType,dist)
calls.enter("sounds.isSoundDangerous",soundType,dist)
	local ret = 
		(
		 ((soundType == "shot") and (dist<getAIConst().dangerSoundShotDist)) or
		 ((soundType == "blast") and (dist<getAIConst().dangerSoundBlastDist)) or
		 ((soundType == "bullet") and (dist<getAIConst().dangerSoundBulletDist))
		)
calls.leave("sounds.isSoundDangerous",dist)
	return(ret)
end,
-------------------------------------------------
resortSounds = function(id)
calls.enter("sounds.resortSounds",id)
	local forget = function(index, sound)
		if(	(time()<sound.time) or
			(time()-sound.time > getAIConst().forgetSoundInterval+math.random(1,10)) or
			(not IsAlive(sound.owner))) then
log(id,"Forget sound", sound.soundID)
			table.remove(Humans[id].memory.clear_sounds,index)
		end
	end

	table.foreach(Humans[id].memory.clear_sounds, forget)

	local isSoundMoreDangerous = function(sound1, sound2)
		local dist1 = service.person2point_distance(id, sound1.x, sound1.y, sound1.z)
		local dist2 = service.person2point_distance(id, sound2.x, sound2.y, sound2.z)
		local isDanger1 = sounds.isSoundDangerous(sound1.type,dist1)
		local isDanger2 = sounds.isSoundDangerous(sound2.type,dist2)
		if(isDanger1) then
			if(isDanger2) then
				return(dist1<dist2)
			else
				return(true)
			end
		elseif(isDanger2) then
			return(false)
		else
			return(dist1<dist2)
		end
	end

	table.sort(Humans[id].memory.clear_sounds,isSoundMoreDangerous)
calls.leave("sounds.resortSounds",id)
end, 
-------------------------------------------------
getCheckedSound = function(id,soundID)
calls.enter("sounds.getCheckedSound",soundID)
	local soundID = Humans[id].check
	local ret = Humans[id].memory.clear_sounds[soundID]
	if(ret==nil) then
		Humans[id].check = NONE		
	end
calls.leave("sounds.getCheckedSound",soundID)
--	ret =  deepcopy(ret)
	return(ret)
end,
-------------------------------------------------
isDangerousSoundPresent = function(id)
calls.enter("sounds.isDangerousSoundPresent",id)
	if(table.getn(Humans[id].memory.clear_sounds)>0) then
		local sound = Humans[id].memory.clear_sounds[1]
		local dist = service.person2point_distance(id, sound.x, sound.y, sound.z)
calls.leave("sounds.isDangerousSoundPresent",id)
		return(sounds.isSoundDangerous(sound.type,dist))
	end
calls.leave("sounds.isDangerousSoundPresent",id)
	return(false)
end,
-------------------------------------------------
getDangerousSound = function(id)
calls.enter("sounds.getDangerousSound",id)
	local sound = nil
	if(table.getn(Humans[id].memory.clear_sounds)>0) then
		sound = Humans[id].memory.clear_sounds[1]
	end
calls.leave("sounds.getDangerousSound",id)
--	sound = deepcopy(sound)
	return(sound)
end,
-------------------------------------------------
removeLastSound = function(id)
calls.enter("sounds.removeLastSound",id)
	if(table.getn(Humans[id].memory.clear_sounds)>0) then
		table.remove(Humans[id].memory.clear_sounds,1)
	end
calls.leave("sounds.removeLastSound",id)
end,
-------------------------------------------------
removeSoundsFrom = function(id,target)
calls.enter("sounds.removeSoundsFrom",id)
	local forget = function(index, sound)
		if(sound.owner==target) then
log(id,"Remove sound", sound.soundID)
			table.remove(Humans[id].memory.clear_sounds,index)
		end
	end
	table.foreach(Humans[id].memory.clear_sounds, forget)
calls.leave("sounds.removeSoundsFrom",id)
end, 
-------------------------------------------------
removeSoundsFromForAll = function(id,target)
calls.enter("sounds.removeSoundsFromForAll",id)
	local forget = function(index, human)
		sounds.removeSoundsFrom(human.id,target)
	end
	table.foreach(Humans, forget)
calls.leave("sounds.removeSoundsFromForAll",id)
end, 
-------------------------------------------------
print = function(id)
	local printSound = function(index, sound)
		log(id,sound.soundID,sound.time,sound.x,sound.y,sound.z)
	end
	table.foreach(Humans[id].memory.clear_sounds, printSound)
end,
}